/****************************************
 *                                      *
 * ļ: 03 ջͶ\09 BankQueuing *
 *                                      *
 * ļ: BankQueuing.c                *
 *                                      *
 *   : 3.63.7                     * 
 *                                      *
 ****************************************/

#ifndef BANKQUEUING_C
#define BANKQUEUING_C

#include "BankQueuing.h" 				//**03 ջͶ**//

/*TTTT[
U 㷨3.6U 
^TTTT*/
void Bank_Simulation_1()				//ҵģ⣬ͳһڿͻжƽʱ 
{
	char eventType;
	
	OpenForDay();						//ʼ

	while(MoreEvent())
	{
		EventDrived(&eventType);		//¼
		
		switch(eventType)
		{
			case 'A': 
				CustomerArrived();
				break;
			case 'D': 
				CustomerDeparture();
				break;
			default : 
				Invalid();
		}
	}
	
	CloseForDay();
}
 
void OpenForDay() 
{	
	int i;
	
	gTotalTime = 0;					//ʼۼʱͿͻΪ0 
	gCustomerNum = 0;
			
	InitList_L(&gEv);				//ʼ¼Ϊձ

	gEn.OccurTime = 0;				//趨һͻ¼ 
	gEn.NType = Arrive;
	 
	OrderInsert(gEv, gEn, cmp);		//¼
	
	for(i=1; i<=4; ++i) 
		InitQueue_L(&gQ[i]);		//ÿն

	Show();
}

Status MoreEvent()
{
	if(!ListEmpty_L(gEv))
		return TRUE;
	else
		return FALSE;
}

void EventDrived(char *event)
{
	ListDelete_L(gEv, 1, &gEn);
	
	if(gEn.NType==Arrive)
		*event = 'A';
	else
		*event = 'D';
}

void CustomerArrived()							//ͻ¼gEn.NType=0 
{	
	int durtime, intertime; 
	int cur_LeftTime, suc_ArrivalTime;
	int i;
	
	++gCustomerNum;								//ܿͻһ 
	
	Random(&durtime, &intertime);				//ɵǰͻҵҪʱһͻﵽʱ
	cur_LeftTime    = gEn.OccurTime + durtime;	//ǰͻ뿪ʱ 
	suc_ArrivalTime = gEn.OccurTime + intertime;//һͻʱ 
			
	gCustomerRcd.ArrivedTime = gEn.OccurTime;	//¼ǰͻϢ 
	gCustomerRcd.Duration    = durtime;
	gCustomerRcd.Count       = gCustomerNum;

	i = Minimum(gQ);							//󳤶̶
	EnQueue_L(&gQ[i], gCustomerRcd); 			//ǰͻ̶
	Show();
	
	if(suc_ArrivalTime<gCloseTime)				//δţһͻ¼¼
	{
		gEn.OccurTime = suc_ArrivalTime;		//gEnĲѾı 
		gEn.NType = Arrive;
		OrderInsert(gEv, gEn, cmp);
	}

	if(QueueLength_L(gQ[i])==1)					//趨iеĶͷͻ뿪¼¼
	{
		gEn.OccurTime = cur_LeftTime;
		gEn.NType = i;		
		OrderInsert(gEv, gEn, cmp);					
	}
}

void CustomerDeparture()						//ͻ뿪¼,gEn.NType>0
{
	int i = gEn.NType;
	
	DeQueue_L(&gQ[i], &gCustomerRcd);			//ɾiеͷͻ
	Show();
		
	gTotalTime += gEn.OccurTime - gCustomerRcd.ArrivedTime;	//ۼƿͻʱ
	
	if(!QueueEmpty_L(gQ[i]))					//趨iеĵһ뿪¼¼ 
	{
		GetHead_L(gQ[i], &gCustomerRcd);
		gEn.OccurTime += gCustomerRcd.Duration;
		gEn.NType = i;
		OrderInsert(gEv,gEn,cmp);
	} 
}

void Invalid()
{
	printf("д");
		exit(OVERFLOW);
}

void CloseForDay()
{
	printf("ܹ%dͻƽʱΪ%dӡ\n",gCustomerNum,gTotalTime/gCustomerNum);
}

int cmp(Event a, Event b)					//Ƚ¼ 
{
	if(a.OccurTime<b.OccurTime)				//ab 
		return -1;
	if(a.OccurTime==b.OccurTime)			//abͬʱ 
		return 0;
	if(a.OccurTime>b.OccurTime)				//ab 
		return 1;
}

void Random(int *durtime, int *intertime)
{
	srand((unsigned)time(NULL));
	*durtime = rand()%DurationTime+1;		//ҵʱ120
	*intertime = rand()%IntervalTime+1; 	//һ˿ʱΪ110 
}

Status OrderInsert(EventList gEv, Event gEn, int (cmp)(Event,Event))
{
	int i;
	EventList p, pre, s;
	
	pre = gEv;
	p = gEv->next;							//pָһ¼ 
	
	while(p && cmp(gEn, p->data)==1)		//gEn¼Ӧòλ
	{
		pre = p;
		p = p->next;
	}
	
	s = (LinkList)malloc(sizeof(LNode));
	if(!s)
		exit(OVERFLOW);
	
	s->data = gEn;							//gEn¼
	s->next = pre->next;
	pre->next = s;
	
	return OK;
}

int Minimum()
{
	int i1 = QueueLength_L(gQ[1]);
	int i2 = QueueLength_L(gQ[2]);
	int i3 = QueueLength_L(gQ[3]);
	int i4 = QueueLength_L(gQ[4]);
	
	if(i1<=i2 && i1<=i3 && i1<=i4)
		return 1;
	if(i2<i1  && i2<=i3 && i2<=i4)
		return 2;
	if(i3<i1  && i3<i2  && i3<=i4)
		return 3;
	if(i4<i1  && i4<i2  && i4<i3 )
		return 4;
}

void Show()
{
	int i;
	QueuePtr p;								//¼Ŀͻǵڼ 
	
	system("cls");
	
	for(i=1; i<=4; i++)
	{
		for(p=gQ[i].front; p; p=p->next)
		{
			if(p==gQ[i].front)
			{
				if(i==1)
					printf("̨١");
				if(i==2)
					printf("̨ڡ");
				if(i==3)
					printf("̨ۡ");
				if(i==4)
					printf("̨ܡ");
			}
			else
				printf("%03d",p->data.Count);			

	
			if(p==gQ[i].rear)
				printf("\n"); 
		}
	}
	
	Wait(SleepTime);
}

/*TTTT[
U 㷨3.7U 
^TTTT*/
void Bank_Simulation_2()
{
	OpenForDay();							//ʼ
	
	while(!ListEmpty_L(gEv))
	{
		ListDelete_L(gEv, 1, &gEn);
		
		if(gEn.NType==Arrive)
			CustomerArrived();				//ͻ¼ 
		else
			CustomerDeparture();			//ͻ뿪¼ 
	}
	
	printf("ܹ%dͻƽʱΪ%dӡ\n",gCustomerNum,gTotalTime/gCustomerNum);//ƽʱ	
}

#endif
